//Javascript document : validations
var validationObjectType=
    {
        'special':/[\W]/,
        'PhoneNo':/^(1?(-?\d{3})-?)?(\d{3})(-?\d{4})$/,
        'MobileNo':/^\d{10,12}$/,
        'Email':/^([0-9a-zA-Z]([-.\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\w]*[0-9a-zA-Z]\.)+[a-zA-Z]{2,9})$/,
        'FaxNo':/([\(\+])?([0-9]{1,3}([\s])?)?([\+|\(|\-|\)|\s])?([0-9]{2,4})([\-|\)|\.|\s]([\s])?)?([0-9]{2,4})?([\.|\-|\s])?([0-9]{4,8})/,
        'Price':/^\$?\d+(\.(\d{2}))?$/,
        'TextOnly':/^[\W]/,
        'PostalCodePart2':/[0-9]{1}[a-zA-Z]{1}[0-9]{1}$/,
        'PostalCodePart1':/[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}$/,
        'PostalCodeFull':/^[a-zA-Z]{1}[0-9]{1}[a-zA-Z]{1}(\-| |){1}[0-9]{1}[a-zA-Z]{1}[0-9]{1}$/,
        'PhoneNoPartOne':/[0-9]{3}/,
        'PhoneNoPartTwo':/[0-9]{3}/,
        'PhoneNoPartThree':/[0-9]{4}/,
        'date':/^(|(0[1-9])|(1[0-2]))\/((0[1-9])|(1\d)|(2\d)|(3[0-1]))\/((\d{4}))$/,
        'date2':/^[0,1]?\d{1}\/(([0-2]?\d{1})|([3][0,1]{1}))\/(([1]{1}[9]{1}[9]{1}\d{1})|([2-9]{1}\d{3}))$/,
        'USZip':/(^(?!0{5})(\d{5})(?!-?0{4})(-?\d{4})?$)/
    }

var mouseIsOverPostalCodeList = false;
var isPasswordOnblurFired = false;

$(document).ready(function(){
	$("#postCodeHintDropDown").hover(
	function(){
		mouseIsOverPostalCodeList = true;
		//alert(mouseIsOverPostalCodeList);
	},
	function(){
		mouseIsOverPostalCodeList = false;
		//alert(mouseIsOverPostalCodeList);
	});

	$("#regPostalCodePartOne").focus(function(){
		if(isPasswordOnblurFired)
		{
			document.getElementById("registerPasswordConfirmTextBox").focus();
			$(this).css({border:'thin solid #BDBDBD'});
			isPasswordOnblurFired = false;
		}
	});
});

//validate(object,val) :
//		This function is used on each input controls 'onblur' event
//		like ..... <input type="text" name="txtEmail" onblur="validate(this,'Email')">
//		it accepts two parameters :
//				1) object - instance of the object
//				2) val - type of regular expression to be validate. 
//						(this value must match one of the element in collection "validationObjectType" declared above)
function validate(object,val)
{
	//get the regular expression.
    var regX = validationObjectType[val];
    var passFail;

    if(object.id=="regPassword"){
		//alert("asdasd");
		isPasswordOnblurFired = true;
        if(object.value.length<4)
            {
                object.className="isInvalid";
                showErrorMessage("Enter minimum 4 charcters","errorMessageStepOneContainer");
                return;
            }
        else
            {
                object.className="isValid";
                hideErrorMessage("errorMessageStepOneContainer");

				if($("#registerPasswordConfirmTextBox").val().length==0)
				{
					showErrorMessage("re-enter password","errorMessageStepOneContainer");
				}
				//alert($("#hiddenFormName").attr("value")=="Register");
				
				if($("#hiddenFormName").attr("value")=="Voucher")
				{
					//Show confirm password box .....
					$("#confirmPasswordLabel").show();
					$("#registerPasswordConfirmTextBox").focus();
					document.getElementById("registerPasswordConfirmTextBox").focus();
                                        if($("#hiddenSelectedTemplate").val()=="1") {
                                                $("#middleContentContainer").css({'top':'192px'});
                                                $("#lineBreakOne").css({'top':'215px'})
                                                $("#registerStepTwoContainer ").css({'top':'290px'})
                                               // $("#regStepThreeContainer").css({'top':'515px'})
                                         } else {
                                        $("#lineBreakOne").css({'top':'215px'});
                                        $("#registerStepTwoContainer").css({'top':'415px'});
                                        //$("#regStepThreeContainer").css({'top':'635px'});
                                        $("#verificationCode").css({'top':'42px'});
                                         }
					//$("#highlightedMessage").css({top:'1480px'});
					if($("#hiddenSelectedLanguage").val()=="french")
				{
					$("#emailMatchingError").css({top:'-10px'});
				}

				}
				else if($("#hiddenFormName").attr("value")=="Register")
				{
					//Show confirm password box .....
					$("#confirmPasswordLabel").show();
					$("#registerPasswordConfirmTextBox").focus();
					document.getElementById("registerPasswordConfirmTextBox").focus();
					//alert("dasd");
					$("#lineBreakOne").css({top:'210px'});
					$("#registerStepTwoContainer").css({top:'300px'});
					//$("#regStepThreeContainer").css({top:'530px'});
					if($("#hiddenSelectedLanguage").val()=="french")
					{
						$("#emailMatchingError").css({top:'-10px'});
					}
					return;
					//$("#highlightedMessage").css({top:'1345px'});
				}
				else if($("#hiddenFormName").attr("value")=="MyProfile")
				{
					//Show confirm password box .....
					/*$("#confirmPasswordLabel").fadeIn();
					$("#registerPasswordConfirmTextBox").focus();
					$("#lineBreakOne").css({top:'310px'});
					$("#registerStepTwoContainer").css({top:'840px'});
					$("#newsLetterDiv").css({top:'230px'});*/
				}
				//document.getElementById("registerPasswordConfirmTextBox").focus();
                return;
				//alert("dasd");
            }
    }

    if(object.value!="")
        {
            if(object.id=="firstNameTextBox" || object.id=="lastNameTextBox" || object.id=="regPassword" || object.id=="registerPasswordConfirmTextBox"|| object.id=="name"|| object.id=="lastName" )
                {
                    object.className="isValid";
					//if(document.getElementById("hiddenFormName2")!=null)
					//{
						  hideErrorMessage("errorMessageStepOneContainer");
					//}

                    return;
                }
            if(object.id=="streetNumberTextBox" ||object.id=="streetNameTextBox")
                {
                    object.className="isValid";
                    hideErrorMessage("errorMessageStepTwoContainer");
                    return;
                }
            //alert(regX+" - "+object.value+" : "+(regX).test(object.value));
            if(!(regX).test(object.value))  //validation fail
            {
                //display error message
                object.style.border = "solid 2px #F72828";

                //add a class to show that this input has invalid data
                object.className = "isInvalid";

                if(document.getElementById("emailMatchingError")!=null)
                {
                    //alert(object.id);
                    if(object.id=="emailTextBox" || object.id=="centeredEmailTextBox" || object.id=="txtForgotPwdEmail")
                    {
                        object.value="Invalid "+val;
                        showCenteredPasswordTextBox();
                        //for opera
                        document.getElementById("firstNameTextBox").className="inputText";
                        hideErrorMessage("errorMessageStepOneContainer");
                    }
                    else
                    {
                        if(object.id=="regPostalCodePartOne"||object.id=="regPostalCodePartTwo")
                        {
                            showErrorMessage("Invalid Postal Code.","errorMessageStepTwoContainer");
                        }
                        else if(object.id=="phoneNoPartOne"||object.id=="phoneNoPartTwo"||object.id=="phoneNoPartThree")
                        {
							if($("#hiddenFormName").attr("value")=="MyProfile")
							{
								showErrorMessage("Invalid Phone number.","errorMessageStepTwoContainer");
							}
							else
							{
								showErrorMessage("Invalid Phone number.","errorMessageStepOneContainer");
							}
                            
                        }
                        else if(object.id=="secondPhoneNoPartOne"||object.id=="secondPhoneNoPartTwo"||object.id=="secondPhoneNoPartThree")
                        {
                            showErrorMessage("Invalid Phone number.","errorMessageStepThreeContainer");
                        }
                        else{
                            document.getElementById("emailNoMatch").innerHTML="Invalid "+val;
                            document.getElementById("emailMatchingError").style.display="block";
                        }
                    }
                    
                    
                    object.style.border="solid thin red";
                }
                else
                {
                    
                    if(object.id=="postCodeOne")
                    {
						//alert(mouseIsOverPostalCodeList);
						if(mouseIsOverPostalCodeList==false)
						{
							//alert(mouseIsOverPostalCodeList);
							document.getElementById("postalCodeErrorBox").style.display="block";
							document.getElementById("postalCodeErrorCenter").innerHTML="Invalid postal code!";
							$("#postCodeHintDropDown").hide();
						}
                        //document.getElementById("postCodeHintDropDown").style.visibility="hidden";
                    }
                    else if(object.id=="postCodeTwo")
                    {
						if(mouseIsOverPostalCodeList==false)
						{
							document.getElementById("postalCodeTwoErrorBox").style.display="block";
							document.getElementById("postalCodeTwoErrorCenter").innerHTML="Invalid postal code!";
							$("#postCodeHintDropDown2").hide();
						}
                        //document.getElementById("postCodeHintDropDown2").style.visibility="hidden";
                    }
                    else
                    {
                        object.value="Invalid "+val;
                    }
                    
                    

                }
		passFail ="failed";

            }
            else  //validation success
            {
                //remove error message
                object.style.border = "";

                //add a class to show that this input has invalid data
                object.className = "isValid";

                if(object.id=="postCodeOne")
                {
                    document.getElementById("postalCodeErrorBox").style.display="none";
                    document.getElementById("postCodeHintDropDown").style.visibility="hidden";
                }
                if(object.id=="postCodeTwo")
                {
                    document.getElementById("postalCodeTwoErrorBox").style.display="none";
                    document.getElementById("postCodeHintDropDown2").style.visibility="hidden";
                }

                if(document.getElementById("emailMatchingError")!=null)
                {
                    //alert(object.id);
                    if(object.id=="regPostalCodePartOne"||object.id=="regPostalCodePartTwo")
                    {
                        hideErrorMessage("errorMessageStepTwoContainer");
                    }
                    else if(object.id=="phoneNoPartOne"||object.id=="phoneNoPartTwo"||object.id=="phoneNoPartThree")
                    {
                        hideErrorMessage("errorMessageStepTwoContainer");
                    }
                    else if(object.id=="secondPhoneNoPartOne"||object.id=="secondPhoneNoPartTwo"||object.id=="secondPhoneNoPartThree")
                    {
                        hideErrorMessage("errorMessageStepThreeContainer");
                    }
                    else{
                        document.getElementById("emailNoMatch").innerHTML="";
                        document.getElementById("emailMatchingError").style.display="none";
                    }
                    
                }
                
                //set the password textbox visible on tab press or blur event of email textbox
                if(object.getAttribute("id")=="emailTextBox"){
                    showPasswordTextBox();
                }
                else if(object.getAttribute("id")=="centeredEmailTextBox"){
                    showCenteredPasswordTextBox();
                    //alert("ad");
                    //for opera 
                    document.getElementById("firstNameTextBox").className="inputText";
                    hideErrorMessage("errorMessageStepOneContainer");
                }
                else if(object.getAttribute("id")=="confirmEmailTextBox"){
                    //Confirm that email is matching
                    matchValues("emailRegTextBox","confirmEmailTextBox");
                }
                	passFail ="passed";
            }

            /*if(object.id=="emailTextBox"){

                //showPasswordTextBox();
                //alert("asd");
            }*/
        }
        else
        {
            object.className = "isInvalid";
            
            if(object.id=="firstNameTextBox")
                {
					if($("#hiddenSelectedLanguage").attr("value")=="french")
					{
						object.value="nom";
					}
					else
					{
						object.value="first name";
					}
                    showErrorMessage("First Name","errorMessageStepOneContainer");
                    return;
                }

            if(object.id=="lastNameTextBox")
                {
					if($("#hiddenSelectedLanguage").attr("value")=="french")
					{
						object.value="nom de famille";
					}
					else
					{
						object.value="last name";
					}
                    
                    showErrorMessage("Last Name","errorMessageStepOneContainer");
                   
                    return;
                }
            if(object.id=="emailRegTextBox")
                {
                    showErrorMessage("Email","errorMessageStepOneContainer");
                    return;
                }
            if(object.id=="confirmEmailTextBox")
                {
					if(object.value.length==0)
					{
					    showErrorMessage("re-enter email","errorMessageStepOneContainer");
						return;
					}
                }
            if(object.id=="regPassword")
                {
                    showErrorMessage("Password","errorMessageStepOneContainer");
                    return;
                }
            if(object.id=="registerPasswordConfirmTextBox")
                {
					if(object.value.length==0)
					{
						showErrorMessage("re-enter password","errorMessageStepOneContainer");

						return;
					}
                }
            if(object.id=="streetNumberTextBox")
                {
                    showErrorMessage("Street Number","errorMessageStepTwoContainer");
                    return;
                }
            if(object.id=="streetNameTextBox")
                {
                    showErrorMessage("Street Name","errorMessageStepTwoContainer");
                    return;
                }
            
			if(object.id=="emailTextBox")
			{
				showDefaultText(object);
				showPasswordTextBox();
				return;
			}

			showDefaultText(object);
            //showDefaultText(object,)
        }
    return passFail;    
}


//validateTextOnly(object,isTextOnlyTrue) :
//			This function is used on textboxes to prevent user from entering wrong data while typing.
//			(where we need to accept only text or numbers)
//			It is called on onkeyup event of the textbox. 
//			like .... <input type="text" name="txtMobile" onkeyup="validateTextOnly(this,false)">
//			This function accepts two parameters :
//					1) object : instance of the object.
//					2) isTextonlyTrue : (boolean) it will have value "true" if we want to accept only characters
//										or "false" if we want to accept only numbers.
function validateTextOnly(object,isTextOnlyTrue)
{

	
    if(isTextOnlyTrue)	//allow only characters
        {
             if((/[a-zA-Z_ ]*$/i).test(object.value))
                object.value = object.value.replace(/[^a-zA-Z_ ]/i,'');
        }
    else				//allow only numbers
        {
			//alert((/[0-9 ]*$/i).test(object.value));
			
            if((/[0-9 ]*$/i).test(object.value))
			{
                object.value = object.value.replace(/[^0-9 ]/i,'');
				
			}
			 
			if(object.value.length==3)
			{
			
					switch (object.id)
					{
					case "phoneNoPartOne":
						document.getElementById("phoneNoPartTwo").focus();
						break;
					case "phoneNoPartTwo":
						document.getElementById("phoneNoPartThree").focus();
						break;
					case "phoneNumberPartOne":
						document.getElementById("phoneNumberPartTwo").focus();
						break;
					case "phoneNumberPartTwo":
						document.getElementById("phoneNumberPartThree").focus();
						break;
					case "secondPhoneNoPartOne":
						document.getElementById("secondPhoneNoPartTwo").focus();
						break;
					case "secondPhoneNoPartTwo":
						document.getElementById("secondPhoneNoPartThree").focus();
						break;
					case "restaurantPhonePartOne":
						document.getElementById("restaurantPhonePartTwo").focus();
						break;
					case "restaurantPhonePartTwo":
						document.getElementById("restaurantPhonePartThree").focus();
						break;
					case "updatePhoneNoPartOne":
						document.getElementById("updatePhoneNoPartTwo").focus();
						break;
					case "updatePhoneNoPartTwo":
						document.getElementById("updatePhoneNoPartThree").focus();
						break;
					default :
						break;
					}

			}
		
        }
}


//matchValues() used for matching the vaules of
//  ....  email and confirm email text boxes and
//  ....  password and PasswordConfirm text boxes.
function matchValues(objectId1,objectId2){
    
    var object1 = document.getElementById(objectId1);
    var object2 = document.getElementById(objectId2);

	if(object2.value.length!=0)
	{
		if(object1.value!=object2.value){

			object2.style.border = "solid 1px #F72828";
			object2.className = "isInvalid";

			document.getElementById("emailNoMatch").innerHTML="Not Matching!";
			document.getElementById("emailMatchingError").style.display="block";
			showErrorMessage("Not Matching!","errorMessageStepOneContainer");
			//object2.focus();
			
		}else{
			
			object2.style.border = "";
			object2.className = "isValid";
			
			document.getElementById("emailNoMatch").innerHTML="";
			document.getElementById("emailMatchingError").style.display="none";
			hideErrorMessage();
		}
	}
	else
	{
		if(object2.id=="registerPasswordConfirmTextBox")
		{
			document.getElementById("emailNoMatch").innerHTML="re-enter password";
			showErrorMessage("re-enter password","errorMessageStepOneContainer");
		}
		else if(object2.id=="confirmEmailTextBox"){
			document.getElementById("emailNoMatch").innerHTML="re-enter email";
			showErrorMessage("re-enter email","errorMessageStepOneContainer");
		}

		document.getElementById("emailMatchingError").style.display="block";
		
	}
}

function removeErrorMessage(object)
{
    if(object.getAttribute("class")=="isInvalid")
        {
            object.value="";

            if(object.id!="captchaText"||object.id!="yourEmail")
                object.style.border="none";
            else
                object.style.border="solid 1px #bdbdbd";

            if(object.id=="yourEmail" || object.id=="removeEmailId")
                object.style.border="thin solid #bdbdbd";
        }
}



function clearValue(object,defaultText)
{    
    if(object.value==defaultText)
    {
        if(object.id=="aptNo" || object.id=="aptBuzzerNoTextBox" || object.id=="updateAptNo" || object.id=="updateBuzzerNo" || object.id=="captchaText" || object.id=="yourName" || object.id=="yourEmail"||object.id=="addressPartTwo"||object.id=="addressPartOne")
            {
                object.style.color="#585656";
                object.style.fontSize="13px";
            }
        object.value="";
    }
    
	if(object.id=="phoneNumberPartOne"||object.id=="phoneNumberPartTwo"||object.id=="phoneNumberPartThree"||object.id=="restaurantPhonePartOne"||object.id=="restaurantPhonePartTwo"||object.id=="restaurantPhonePartThree")
		return;

	
	removeErrorMessage(object);
	


}


function setFunctionByClassName()
{
    
    if (document.getElementsByClassName == undefined) {
            document.getElementsByClassName = function(className)
            {
                    var hasClassName = new RegExp("(?:^|\\s)" + className + "(?:$|\\s)");
                    var allElements = document.getElementsByTagName("*");
                    var results = [];

                    var element;
                    for (var i = 0; (element = allElements[i]) != null; i++) {
                            var elementClass = element.className;
                            if (elementClass && elementClass.indexOf(className) != -1 && hasClassName.test(elementClass))
                                    results.push(element);
                    }

                    return results;
            }
    }

}

/*function clearForm()
{
    //var elem = document.forms[form].elements;
    
    for(var i=0;i<elem.length;i++)
        {
            if(form!=6)
            {
                if(elem[i].type=="checkbox" || elem[i].type=="radio")
                  elem[i].checked=false;
            }
            if(elem[i].type=="text" || elem[i].type=="textarea" || elem[i].type=="file")
                  elem[i].value = "";
            //alert(elem[i].type);
        }
   //alert(elem.length);
}*/

function validatePhoneNumber(object){
    if(object.value.length<3)
        {
            object.className="isInvalid";
            showErrorMessage("Invalid Phone Number","errorMessageStepThreeContainer");
        }
    else
        {
            object.className="isValid";
            hideErrorMessage("errorMessageStepThreeContainer");
        }
        
}

function validatePhoneNumberThree(object){
    if(object.value.length<4)
        {
            object.className="isInvalid";
            showErrorMessage("Invalid Phone Number","errorMessageStepThreeContainer");
        }
    else
        {
            object.className="isValid";
            hideErrorMessage("errorMessageStepThreeContainer");
            //showVerificationCodeTextBox();
            
        }
}

function checkTabIndex(){
/*    if(document.getElementById("centeredEmailTextBox").value.length>0 && document.getElementById("centeredPasswordTextBox").value.length==0){
        
        document.getElementById("firstNameTextBox").className="inputText";
        document.getElementById("firstNameTextBox").style.border="thin solid #bdbdbd";
        
        showCenteredPasswordTextBox();
        document.getElementById("centeredPasswordTextBox").focus();
        hideErrorMessage("errorMessageStepOneContainer");
    }*/
}


function validateCode(obj)
{
    var codeValue = obj.value;
    if(validate(obj,"PostalCodeFull")=="failed")
    {
        obj.value=codeValue;
        if(validate(obj,"USZip")=="failed")
            {
                  obj.value = "Invalid Code";
            }
    }
    
}
